%This program runs the simulations behind Fig. 8.
%It conducts 1000 experiments of 1.10^6 episodes, with \sigma = 5
%\Delta_v = 4, and the number of AMM N between 2 and 10, 
%and records all the variables in the last episode.

%The program first runs the adverse selection case and then the private values case.

clear

% record running time
% when producing the data the running time was around 13 hours.
tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.      

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l = 5 ;       

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',7);

% Simulate for 9 values of N, adverse selection case:

for N = 2:10
    %Display N to follow the execution of the program
    disp(N)
    %Call the function simulation_rep to run K experiments
    [last_episodes, ~]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
    %Save the output in the subfolder "Data"
    writematrix(last_episodes,sprintf("Data/last_episodes_%d.txt",N));
end

%Simulate for 9 values of N, private values case:

for N = 2:10
    %Display N to follow the execution of the program
    disp(N)
    %Call the function simulation_rep_private to run K experiments
    [last_episodes, ~]=simulation_rep_private(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
    %Save the output in the subfolder "Data"
    writematrix(last_episodes,sprintf("Data/last_episodes_private_%d.txt",N));
end

toc